echo -off

load bin\uefi64.efi

set hba_id 9230
set MVF mvf.efi
set parmfile setparm.nsh
set BOARD hba
set ad_id 0
if not exist %DEV_LIST% then 
    set DEV_LIST -d
endif
if not exist %OPTS% then
    set OPTS -d
endif
if not exist %ONCE% then
    set ONCE -d
endif
if not exist %ADCOUNT% then
    set ADCOUNT -d
endif
if not exist %READIMG% then
    set READIMG -d
endif
if not exist %READSPIIMG% then
    set READSPIIMG -d
endif
if not exist %ERASE% then
    set ERASE -d
endif


#if not exist %OPTS% then
#endif    

:loop

if exist %1% then
    goto DO_FLASH
endif

if %1% == help then
    echo that will print messages for teaching you how to use the tool.
    goto help
endif

if %1% == w then
    set ERASE CHIP
    goto next
endif
if %1% == e then
    set ERASE SECTOR
    goto next
endif
#if %1% == a then
#    set OPTS_1 %1
#    goto next
#ednif
if %1% == y then
    set OPTS %1
    goto next
endif
#if %1% == b then
#    set OPTS_1 %1
#    set OPTS_2 %2
#    goto next
#endif
#if %1% == x then
#    set OPTS_1 %1
#    goto next
#endif
#if %1% == v then
#    set OPTS_1 %1
#    goto next
#endif
if %1% == r then
    set READIMG 1
    goto next
endif
if %1% == ra then
    set READSPIIMG 1
    goto next
endif
if %1% == adid then 
    set ONCE 1
    set ad_id %2
    goto next
endif
if %1% == fdid then
    set hba_id %2
    goto next
endif
goto fail_command

:next

if %1% == adid then
    shift
endif

if %1% == fdid then
    shift
endif

shift
goto loop

:DO_FLASH
if %hba_id% == generic then
    goto end
endif

if %ONCE% == 1 then
    set CRTID %ad_id%
endif

cd bin
%MVF% -getparm %parmfile% -cdid %hba_id% -adid %ad_id%
%parmfile%
del %parmfile%
echo -off
cd ..

if exist %ADCOUNT then
    goto end
endif
if %ADCOUNT% == 0 then
    goto end
endif
if %ADCOUNT% == 5 then
    goto end
endif
if %ADCOUNT% == 6 then
    goto end
endif
if %ADCOUNT% == 7 then
    goto end
endif

if %REVID% == 10 then
    set IMAGFILE ImageA0.bin
endif
if %REVID% == 11 then
    set IMAGFILE ImageA1.bin
endif
#set IMAGFILE ImageA0.bin
#set IMAGFILE ImageA1.bin
if exist %REVID% then
    goto end
endif
if exist %IMAGFILE% then
    goto end
endif
echo ----------------------------------------------------------------------
echo                           MARVELL FLASH TOOL
echo ----------------------------------------------------------------------

cd bin

if %ERASE% == CHIP then
    goto CHIP_ERASE_STEP
endif
if %ERASE% == SECTOR then
    goto SECTOR_ERASE_STEP
endif
if %READIMG% == 1 then
    goto READ_IMG_STEP
endif
if %READSPIIMG% == 1 then
    goto DUMP_SPI_IMG_STEP
endif

if %OPTS% == y then
%MVF% -wbf %IMAGFILE% -addr 0 -cdid %hba_id% -adid %ad_id% -y
else
%MVF% -wbf %IMAGFILE% -addr 0 -cdid %hba_id% -adid %ad_id%
endif
goto IMG_END_SETP

:CHIP_ERASE_STEP
if %OPTS% == y then
%MVF% -wpa -cdid %hba_id% -adid %ad_id% -y
else
%MVF% -wpa -cdid %hba_id% -adid %ad_id%
endif
goto IMG_END_SETP

:SECTOR_ERASE_STEP
if %OPTS% == y then
%MVF% -se -wbf %IMAGFILE% -addr 0 -cdid %hba_id% -adid %ad_id% -y
else
%MVF% -se -wbf %IMAGFILE% -addr 0 -cdid %hba_id% -adid %ad_id%
endif
goto IMG_END_SETP

:READ_IMG_STEP
%MVF% -rfb bkimg%ad_id%.bin -addr 0 -sz 0x1fb000 -cdid %hba_id% -adid %ad_id%
goto IMG_END_SETP

:DUMP_SPI_IMG_STEP
%MVF% -rfb bkimg%ad_id%.bin -addr 0 -sz %FlashSize% -cdid %hba_id% -adid %ad_id%

:IMG_END_SETP
cd ..

if %ONCE% == 1 then
    goto check_error
endif

if %ADCOUNT% == 1 then
    goto check_error
endif

if %ad_id% == 3 then
    set ad_id 4
endif

if %ad_id% == 2 then
    set ad_id 3
endif

if %ad_id% == 1 then
    set ad_id 2
endif

if %ad_id% == 0 then
    set ad_id 1
endif

if %ad_id% == %ADCOUNT% then
    goto check_error
endif

goto do_flash

:check_error
#echo Flash error, wipeout autoload!!
#cd bin
#%MVF% -wpa -y
#cd ..
goto end

:erase
if exist %BOARD% then
    goto help
endif

echo erase for %BOARD%...
goto erase%BOARD%
goto end

#Do help screen
:help
echo **********************************************************************
echo                        MARVELL FLASH TOOL HELP
echo **********************************************************************
echo type 'go'         Update Magni Firmware
echo type 'go y'      Update Magni Firmware with Yes included
#Have split screen

if %OPTS% == v then
    goto detailed
endif

shift

if %1% == v then
    goto detailed
endif

echo type 'go h'      Display simple help screen (this screen)
goto end
:detailed
echo type 'go h v'   Display detailed help screen (this screen)
echo type 'go e'      Erase every sector
echo type 'go a'      Flash only autoload
echo type 'go b'      Flash only BIOS on MAGNI
echo type 'go b e'   Erase only BIOS
echo type 'go x'      Flash only Firmware on MAGNI
echo type 'go x e'   Erase only Firmware on MAGNI
echo type 'go v'      Show verbose message
echo type 'go r'      Read back binary file, no flashing
echo type 'go ra'     Dump the data of Spiflash to a binary file
echo type 'go aid 0'  Update the specified the adapter 0
goto end

:fail_end
echo Did not find device! Check connection.
goto end

:fail_command
echo Bad Command.  Please check with help!
goto end

:end
if not exist %myval% then
set myval -d
endif
if not exist %ERASE% then
set ERASE -d
endif
if not exist %AD_ID% then
set AD_ID -d
endif
if not exist %HBA_ID% then
set HBA_ID -d
endif
if not exist %ADCOUNT% then
set ADCOUNT -d
endif
if not exist %CRTID% then
set CRTID -d
endif
if not exist %SPIFLASHSIZE% then
set SPIFLASHSIZE -d
endif
if not exist %BOARD% then
set BOARD -d
endif
if not exist %NORAID% then
set NORAID -d
endif
if not exist %OPTS% then
set OPTS -d
endif
if not exist %ERASE% then
set ERASE -d
endif
if not exist %MVF% then
set MVF -d
endif
if not exist %IMAGE% then
set IMAGE -d
endif
if not exist %cmdline% then
set cmdline -d
endif
if not exist %IMAGFILE% then
set IMAGFILE -d
endif
if not exist %REVID% then
set REVID -d
endif
if not exist %parmfile% then
set parmfile -d
endif
echo -on